<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis Nastavení zaměření</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis Nastavení zaměření</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="SurveyFieldbook">
                                <table class="margin" cellpadding="2" width="80%">
                                    <tbody>
                                        <tr>
                                            <th align="right"  lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Jednotky:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@surveyLinearUnits"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />
                                <!-- Survey Setup Data -->
                                <xsl:for-each select="SurveyStationList">
                                    <table class="margin" cellpadding="2" cellspacing="1" width="100%">
                                        <colgroup span="2">
                                            <col width="30%"/>
                                            <col width="70%"/>
                                        </colgroup>
                                        <tbody>
                                            <xsl:for-each select="SurveyStation">
                                                <tr>
                                                    <th align="right" lang="en">Název:&#xa0; </th>
                                                    <td><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Výška stroje:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="cif:distanceFormat(number(@instrumentHeight))"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Obsazený bod:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@occupiedPoint"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Zpětný bod:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@backSightPoint"/>
                                                    </td>                                                    
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Zpětný směr:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="cif:angularFormat(number(@backSightDirection))"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Zpětný Typ:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@backSightType"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Kruh:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="cif:angularFormat(number(@circle))"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Std. chyba směru:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="cif:angularFormat(number(@standardErrorDirection))"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Datový soubor:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@dataFile"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Polní zápisník:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@fieldBook"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en">Časová značka:&#xa0; </th>
                                                    <td>
                                                        <xsl:value-of select="@timeStamp"/>
                                                    </td>
                                                </tr>
                                                <tr><td colspan="2">&#xa0;</td></tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
        <p class="normal1" lang="en">
                Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jedno nastavení měření.</p>

		<p class="normal1">Pro nejlepší výsledek spusťte výpis z panelu Detaily. Vyberte všechna nastavení v Průzkumníku projektu, která jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
		</p>
		<p class="normal1">Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku. </p>
            <p class="normal1">Jakmile je otevřený Průzkumník výpisů, zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
